/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.fsp.cmdhelpers;

import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.FSPCmdMgr;
import java.util.Hashtable;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class FspLparProcessingInfo {
    private UnsignedInt8 mProcType;
    private UnsignedInt8 mSharingMode;
    private UnsignedInt8 mUncappedWeight;
    private UnsignedInt16 mMinProcs;
    private UnsignedInt16 mAllocProcs;
    private UnsignedInt16 mMaxProcs;
    private UnsignedInt32 mMinProcUnits;
    private UnsignedInt32 mAllocProcUnits;
    private UnsignedInt32 mMaxProcUnits;
    private UnsignedInt16 mProcs;
    private UnsignedInt32 mProcUnits;
    static final int DEDICATED = 255;
    private static final String GET_CURRENT_LPAR_PROCESSING = "GET_CURRENT_LPAR_PROCESSING";
    private static final String GET_PENDING_LPAR_PROCESSING = "GET_PENDING_LPAR_PROCESSING";
    private static final String GET_RUNTIME_LPAR_PROCESSING = "GET_RUNTIME_LPAR_PROCESSING";
    private static final String IS_SHARED = "IS_SHARED";
    private static final String IS_UNCAPPED = "IS_UNCAPPED";
    private static final String MIN_DEDICATED_PROCS = "MIN_DEDICATED_PROCS";
    private static final String DEDICATED_PROCS = "DEDICATED_PROCS";
    private static final String MAX_DEDICATED_PROCS = "MAX_DEDICATED_PROCS";
    private static final String MIN_VIRTUAL_PROCS = "MIN_VIRTUAL_PROCS";
    private static final String VIRTUAL_PROCS = "VIRTUAL_PROCS";
    private static final String MAX_VIRTUAL_PROCS = "MAX_VIRTUAL_PROCS";
    private static final String MIN_SHARED_PROCS = "MIN_SHARED_PROCS";
    private static final String PROC_UNITS = "PROC_UNITS";
    private static final String SHARED_PROCS = "SHARED_PROCS";
    private static final String MAX_SHARED_PROCS = "MAX_SHARED_PROCS";
    private static final String UNCAPPED_WEIGHT = "UNCAPPED_WEIGHT";

    public String toString() {
        String string = "procType=";
        String string2 = "sharingMode=";
        String string3 = "uncappedWeight=";
        String string4 = "minProcs=";
        String string5 = "allocProcs=";
        String string6 = "maxProcs=";
        String string7 = "minProcUnits=";
        String string8 = "allocProcUnits=";
        String string9 = "maxProcUnits=";
        if (this.mProcType != null) {
            string = string + this.mProcType.toString();
        }
        if (this.mSharingMode != null) {
            string2 = string2 + this.mSharingMode.toString();
        }
        if (this.mUncappedWeight != null) {
            string3 = string3 + this.mUncappedWeight.toString();
        }
        if (this.mMinProcs != null) {
            string4 = string4 + this.mMinProcs.toString();
        }
        if (this.mAllocProcs != null) {
            string5 = string5 + this.mAllocProcs.toString();
        }
        if (this.mMaxProcs != null) {
            string6 = string6 + this.mMaxProcs.toString();
        }
        if (this.mMinProcUnits != null) {
            string7 = string7 + this.mMinProcUnits.toString();
        }
        if (this.mAllocProcUnits != null) {
            string8 = string8 + this.mAllocProcUnits.toString();
        }
        if (this.mMaxProcUnits != null) {
            string9 = string9 + this.mMaxProcUnits.toString();
        }
        return string + "; " + string2 + "; " + string3 + "; " + string4 + "; " + string5 + "; " + string6 + "; " + string7 + "; " + string8 + "; " + string9;
    }

    FspLparProcessingInfo getCurrentLparProcessingCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        this.getCurrentPendingLparProcessingCmd(GET_CURRENT_LPAR_PROCESSING, fSPCmdMgr, unsignedInt16);
        return this;
    }

    FspLparProcessingInfo getPendingLparProcessingCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        this.getCurrentPendingLparProcessingCmd(GET_PENDING_LPAR_PROCESSING, fSPCmdMgr, unsignedInt16);
        return this;
    }

    FspLparProcessingInfo getRuntimeLparProcessingCmd(FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        System.out.println("before calling GET_RUNTIME_LPAR_PROCESSING lparId: " + unsignedInt16);
        hashtable = fSPCmdMgr.doPhypCommand(GET_RUNTIME_LPAR_PROCESSING, new String[]{unsignedInt16.toString()});
        System.out.println("after calling GET_RUNTIME_LPAR_PROCESSING resp: " + hashtable);
        this.mProcType = (UnsignedInt8)hashtable.get(IS_SHARED);
        this.mSharingMode = (UnsignedInt8)hashtable.get(IS_UNCAPPED);
        if (this.mProcType.intValue() == 255) {
            this.mAllocProcs = (UnsignedInt16)hashtable.get(DEDICATED_PROCS);
        } else {
            this.mAllocProcs = (UnsignedInt16)hashtable.get(VIRTUAL_PROCS);
            this.mAllocProcUnits = (UnsignedInt32)hashtable.get(PROC_UNITS);
            this.mUncappedWeight = (UnsignedInt8)hashtable.get(UNCAPPED_WEIGHT);
        }
        return this;
    }

    private void getCurrentPendingLparProcessingCmd(String string, FSPCmdMgr fSPCmdMgr, UnsignedInt16 unsignedInt16) throws PIHscServerException, PIHscCmdMgrException {
        Hashtable hashtable = null;
        hashtable = fSPCmdMgr.doPhypCommand(string, new String[]{unsignedInt16.toString()});
        this.mProcType = (UnsignedInt8)hashtable.get(IS_SHARED);
        this.mSharingMode = (UnsignedInt8)hashtable.get(IS_UNCAPPED);
        if (this.mProcType.intValue() == 255) {
            this.mMinProcs = (UnsignedInt16)hashtable.get(MIN_DEDICATED_PROCS);
            this.mAllocProcs = (UnsignedInt16)hashtable.get(DEDICATED_PROCS);
            this.mMaxProcs = (UnsignedInt16)hashtable.get(MAX_DEDICATED_PROCS);
        } else {
            this.mMinProcs = (UnsignedInt16)hashtable.get(MIN_VIRTUAL_PROCS);
            this.mAllocProcs = (UnsignedInt16)hashtable.get(VIRTUAL_PROCS);
            this.mMaxProcs = (UnsignedInt16)hashtable.get(MAX_VIRTUAL_PROCS);
            this.mMinProcUnits = (UnsignedInt32)hashtable.get(MIN_SHARED_PROCS);
            this.mAllocProcUnits = (UnsignedInt32)hashtable.get(SHARED_PROCS);
            this.mMaxProcUnits = (UnsignedInt32)hashtable.get(MAX_SHARED_PROCS);
            this.mUncappedWeight = (UnsignedInt8)hashtable.get(UNCAPPED_WEIGHT);
        }
    }

    public UnsignedInt8 getProcType() {
        return this.mProcType;
    }

    public UnsignedInt8 getSharedProcessorPoolId() {
        return this.mProcType;
    }

    public void setProcType(UnsignedInt8 unsignedInt8) {
        this.mProcType = unsignedInt8;
    }

    public UnsignedInt8 getSharingMode() {
        return this.mSharingMode;
    }

    public UnsignedInt8 getCappedMode() {
        return this.mSharingMode;
    }

    public void setSharingMode(UnsignedInt8 unsignedInt8) {
        this.mSharingMode = unsignedInt8;
    }

    public UnsignedInt8 getUncappedWeight() {
        return this.mUncappedWeight;
    }

    public void setUncappedWeight(UnsignedInt8 unsignedInt8) {
        this.mUncappedWeight = unsignedInt8;
    }

    public UnsignedInt16 getMinProcs() {
        return this.mMinProcs;
    }

    public void setMinProcs(UnsignedInt16 unsignedInt16) {
        this.mMinProcs = unsignedInt16;
    }

    public UnsignedInt16 getAllocProcs() {
        return this.mAllocProcs;
    }

    public void setAllocProcs(UnsignedInt16 unsignedInt16) {
        this.mAllocProcs = unsignedInt16;
    }

    public UnsignedInt16 getMaxProcs() {
        return this.mMaxProcs;
    }

    public void setMaxProcs(UnsignedInt16 unsignedInt16) {
        this.mMaxProcs = unsignedInt16;
    }

    public UnsignedInt32 getMinProcUnits() {
        return this.mMinProcUnits;
    }

    public void setMinProcUnits(UnsignedInt32 unsignedInt32) {
        this.mMinProcUnits = unsignedInt32;
    }

    public UnsignedInt32 getAllocProcUnits() {
        return this.mAllocProcUnits;
    }

    public void setAllocProcUnits(UnsignedInt32 unsignedInt32) {
        this.mAllocProcUnits = unsignedInt32;
    }

    public UnsignedInt32 getMaxProcUnits() {
        return this.mMaxProcUnits;
    }

    public void setMaxProcUnits(UnsignedInt32 unsignedInt32) {
        this.mMaxProcUnits = unsignedInt32;
    }

    public UnsignedInt8 getRuntimeProcMode() {
        return this.mProcType;
    }

    public void setRuntimeProcMode(UnsignedInt8 unsignedInt8) {
        this.mProcType = unsignedInt8;
    }

    public UnsignedInt8 getRuntimeSharingMode() {
        return this.mSharingMode;
    }

    public void setRuntimeSharingMode(UnsignedInt8 unsignedInt8) {
        this.mSharingMode = unsignedInt8;
    }

    public UnsignedInt8 getRuntimeUncappedWeight() {
        return this.mUncappedWeight;
    }

    public void setRuntimeUncappedWeight(UnsignedInt8 unsignedInt8) {
        this.mUncappedWeight = unsignedInt8;
    }

    public UnsignedInt16 getRuntimeProcs() {
        return this.mAllocProcs;
    }

    public void setRuntimeProcs(UnsignedInt16 unsignedInt16) {
        this.mAllocProcs = unsignedInt16;
    }

    public UnsignedInt32 getRuntimeProcUnits() {
        return this.mAllocProcUnits;
    }

    public void setRuntimeProcUnits(UnsignedInt32 unsignedInt32) {
        this.mAllocProcUnits = unsignedInt32;
    }
}

